/*
 *	PVM 2.4
 *	University of Tennesee, Knoxville, TN.
 *	Oak Ridge National Laboratory, Oak Ridge, TN.
 *	31 Dec 1991
 *
 *	Pvmuser.h
 *
 *	Interface defines for libpvm.
 *
$Log: pvmuser.h,v $
 * Revision 1.8  1992/05/21  18:37:43  manchek
 * added check for multiple include.
 * added extern "C" declaration for C++
 *
 * Revision 1.7  1992/03/18  19:07:53  manchek
 * added decl for pvm_inithow() and defs for PvmDataDefault and Raw.
 * added def for PvmBadMsg for rcv and variants
 *
 * Revision 1.6  1992/03/16  19:11:49  manchek
 * added pvm_mstat and pvm_perror prototypes
 *
 * Revision 1.5  1992/03/12  22:04:50  manchek
 * added (void) to prototypes for initsend and leave
 * to indicate no args
 *
 * Revision 1.4  1992/01/24  19:20:41  manchek
 * changed PvmSyserr to PvmSysErr
 *
 * Revision 1.3  1992/01/23  23:23:28  manchek
 * added PvmAlready error code
 *
 * Revision 1.2  1992/01/22  00:53:22  manchek
 * added function definitions/prototypes
 *
 * Revision 1.1  1991/12/31  23:16:36  manchek
 * Initial revision
 *
 *
 */

#ifndef PvmOk

/*
*	Error return codes from libpvm calls
*/

#define	PvmOk			0	/* okay */
#define	PvmSysErr		-1	/* some system error */
#define	PvmBadParam		-2	/* bad parameter (neg msg id, etc) */
#define	PvmMismatch		-3	/* barrier count mismatch */
#define	PvmTooLong		-4	/* name too long (32) */
#define	PvmNoData		-5	/* read past end of buffer */
#define	PvmNoHost		-6	/* no such host */
#define	PvmNoFile		-7	/* no such executable */
#define	PvmNoComp		-8	/* no such process component */
#define	PvmNoMsg		-9	/* no message available */
#define	PvmNoMem		-10	/* can't get memory */
#define	PvmAlready		-11	/* process already enrolled */
#define	PvmBadMsg		-12	/* received msg can't be decoded */

/*
*	Data conversion options for pvm_inithow
*/

#define PvmDataDefault	0	/* use LCD algorithm */
#define PvmDataRaw		1	/* do no data conversion */

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif
#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#ifdef __cplusplus
extern "C" {
#endif

int		barrier		__ProtoGlarp__((char *name, int num));
int		enroll		__ProtoGlarp__((char *proc));
int		getbytes	__ProtoGlarp__((char *cp, int n));
int		getncplx	__ProtoGlarp__((float *xp, int n));
int		getndcplx	__ProtoGlarp__((double *zp, int n));
int		getndfloat	__ProtoGlarp__((double *dp, int n));
int		getnfloat	__ProtoGlarp__((float *fp, int n));
int		getnint		__ProtoGlarp__((int *np, int n));
int		getnlong	__ProtoGlarp__((long *np, int n));
int		getnshort	__ProtoGlarp__((short *np, int n));
int		getstring	__ProtoGlarp__((char *cp));
int		initiate	__ProtoGlarp__((char *proc, char *arch));
int		initiateM	__ProtoGlarp__((char *proc, char *host));
void	initsend	__ProtoGlarp__((void));
int		pvm_inithow	__ProtoGlarp__((int how));
void	leave		__ProtoGlarp__((void));
int		pvm_mstat	__ProtoGlarp__((int *na, int **hsa, char*** hna, char*** haa));
void	pvm_perror	__ProtoGlarp__((char *s));
int		probe		__ProtoGlarp__((int mt));
int		probemulti	__ProtoGlarp__((int ntypes, int *mta));
int		pstatus		__ProtoGlarp__((int *ncpu, int *mixed));
int		putbytes	__ProtoGlarp__((char *cp, int n));
int		putncplx	__ProtoGlarp__((float *xp, int n));
int		putndcplx	__ProtoGlarp__((double *zp, int n));
int		putndfloat	__ProtoGlarp__((double *dp, int n));
int		putnfloat	__ProtoGlarp__((float *fp, int n));
int		putnint		__ProtoGlarp__((int *np, int n));
int		putnlong	__ProtoGlarp__((long *np, int n));
int		putnshort	__ProtoGlarp__((short *np, int n));
int		putstring	__ProtoGlarp__((char *cp));
int		rcv			__ProtoGlarp__((int mt));
int		rcvinfo		__ProtoGlarp__((int *len, int *mt, char *proc, int *inst));
int		rcvmulti	__ProtoGlarp__((int ntypes, int *mta));
int		ready		__ProtoGlarp__((char *event));
int		snd			__ProtoGlarp__((char *proc, int inst, int mt));
int		status		__ProtoGlarp__((char *proc, int inst));
int		terminate	__ProtoGlarp__((char *proc, int inst));
int		vrcv		__ProtoGlarp__((int mt));
int		vrcvmulti	__ProtoGlarp__((int ntypes, int *mta));
int		vsnd		__ProtoGlarp__((char *proc, int inst, int mt));
int		waituntil	__ProtoGlarp__((char *event));
int		whoami		__ProtoGlarp__((char *proc, int *inst));

#ifdef __cplusplus
}
#endif

#endif /*PvmOk*/

